# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import os
import logging

from ..utils.json import load_json, save_json
from ..utils.time import get_now_ts


class JsonHolder(object):
    def __init__(self, config=None):
        super(JsonHolder, self).__init__()
        self.config = config
        self.logger = logging.getLogger(__name__)

    def load(self, path):
        if os.path.exists(path) and 'ttl' in self.config:
            if get_now_ts() - int(os.path.getctime(path)) > self.config['ttl']:
                self.logger.info('File\'s {} ttl expired. Deleting it.'.format(path))
                os.remove(path)
        try:
            data = load_json(path)
            self.logger.info('{} loaded successfully.'.format(path))
        except (ValueError, TypeError, OSError, IOError) as error:
            self.logger.error('Failed to load {}. Error: {}.'.format(path, error))
            data = {}
        return data

    def save(self, path, data):
        try:
            save_json(path, data)
            self.logger.info('{} saved successfully.'.format(path))
        except (ValueError, TypeError, OSError, IOError) as error:
            self.logger.error('Failed to save {}. Error: {}.'.format(path, error))
