# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import pebble
import logging
import traceback

from .monitoring_manager import MonitoringManager


class TimeoutMonitoringManager(MonitoringManager):
    def __init__(self, name, config):
        super(TimeoutMonitoringManager, self).__init__(name, config)
        self.logger = logging.getLogger(__name__)

    def _run_internal(self, function, config):
        try:
            if self.config['timeout'] is not None:
                with pebble.ProcessPool(max_workers=1) as pool:
                    future = pool.schedule(
                        function,
                        args=(config,),
                        kwargs={},
                        timeout=self.config['timeout']
                    )
                future.result()
            else:
                function(config)
        except Exception as error:
            self.logger.critical(
                'Monitoring: {}\nAn unexpected error occured: {}\n{}'.format(
                    self.name,
                    error,
                    getattr(error, 'traceback', traceback.format_exc())
                )
            )
