# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging


def merge_dictionaries_custom(old, new, merge_method):
    merged = {}
    all_keys = set(old.keys()) | set(new.keys())
    for key in all_keys:
        if key in old and key in new:
            old_value = old[key]
            new_value = new[key]
            if isinstance(old_value, dict) and isinstance(new_value, dict):
                merged[key] = merge_dictionaries_custom(old_value, new_value, merge_method)
            else:
                merged[key] = merge_method(old_value, new_value)
        elif key in new:
            merged[key] = new[key]
        else:
            merged[key] = old[key]
    return merged


class JsonMergerBase(object):
    def __init__(self):
        super(JsonMergerBase, self).__init__()
        self.logger = logging.getLogger(__name__)

    def merge(self, old_stats, new_stats):
        raise NotImplementedError('{}.merge'.format(self.__class__.__name__))
