# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .json_merger_base import JsonMergerBase, merge_dictionaries_custom


class RtmrJsonMergerBase(JsonMergerBase):
    def __init__(self):
        super(RtmrJsonMergerBase, self).__init__()
        self.logger = logging.getLogger(__name__)

    def merge(self, old_stats, new_stats):
        self.logger.info('Merging stats for old keys')
        self.logger.info('{}'.format(old_stats.keys()))
        self.logger.info('with stat for new keys')
        self.logger.info('{}'.format(new_stats.keys()))
        merged_stats = merge_dictionaries_custom(old_stats, new_stats, self._merge_internal)
        self.logger.info('Merging completed')
        return merged_stats

    def _merge_internal(self, old_value, new_value):
        raise NotImplementedError('{}._merge_internal'.format(self.__class__.__name__))
