# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import pandas
import logging

from .atom_monitorer_base import AtomMonitorerBase


class AtomAbsMonitorerBase(AtomMonitorerBase):
    def __init__(self, pusher, provider, aggregator):
        super(AtomAbsMonitorerBase, self).__init__(pusher, provider)
        self.logger = logging.getLogger(__name__)
        self.aggregator = aggregator

    def _run_internal(self, urls):
        new_stats = self._get_new_stats(urls)
        absolutes = self.__compute_absolutes(new_stats)
        self.pusher.push(absolutes)

    def __compute_absolutes(self, stats):
        return self.aggregator.aggregate(self._collect(stats))

    def _collect(self, stats):
        raise NotImplementedError('{}._collect'.format(self.__class__.__name__))

