# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from nile.api.v1 import extractors as ne

from .nile_monitorer import NileMonitorer


class AtomDistributionMonitorer(NileMonitorer):
    def __init__(self, date, pusher, provider, merger, aggregator, config):
        super(AtomDistributionMonitorer, self).__init__(pusher, config)
        self.logger = logging.getLogger(__name__)
        self.date = date
        self.provider = provider
        self.merger = merger
        self.aggregator = aggregator

    def run(self):
        self.logger.info('{}: BUILDING ATOM DISTRIBUTION CUBE AND REPORT'.format(self.__class__.__name__))
        self.logger.info('DATE: {}'.format(self.date))
        self._run_internal()
        self.logger.info('CUBE AND REPORT COMPLETED')

    def _construct_job(self, cluster, job):
        extracts = {}
        for name, info in self.config['sources'].items():
            shift = info.get('date_shift', 0)
            path = self._get_path(info['path_pattern'], self.date, shift)
            if cluster.driver.exists(path):
                extracts[name] = self.provider.get(name, job.table(path))
            else:
                extracts[name] = None
        targets = self.aggregator.aggregate(self.merger.merge(extracts))
        targets['totals'] = targets['totals'].project(
            ne.all(),
            date=ne.const(self.date)
        )
        for name, stream in targets.items():
            stream.put(self._get_path(self.config['targets'][name]['path_pattern'], self.date))
        self.pusher.push(targets['totals'])

    def _post_process(self, cluster):
        for name in ['atom_cube', 'totals']:
            path = self._get_path(self.config['targets'][name]['path_pattern'], self.date)
            self.logger.info('Setting schema for tabe {}'.format(path))
            cluster.driver.set_attribute(path, '_read_schema', self.config['schemas'][name])
