# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import datetime
import logging

from .monitorer_base import MonitorerBase


class AtomMonitorerBase(MonitorerBase):
    def __init__(self, pusher, provider):
        super(AtomMonitorerBase, self).__init__(pusher)
        self.logger = logging.getLogger(__name__)
        self.provider = provider

    def _get_new_stats(self, urls):
        stats = {}
        for key, url in urls.items():
            stats[key] = self.provider.get(url)
            update_ts = stats[key]['update_ts']
            self.logger.info(
                'Timestamp for key {} : {} i.e. {}'.format(
                    key, update_ts, datetime.datetime.fromtimestamp(update_ts)
                )
            )
        return stats
