# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .monitorer_base import MonitorerBase


class ClickhouseAtomYaStatMonitorer(MonitorerBase):
    def __init__(self, pusher, config):
        super(ClickhouseAtomYaStatMonitorer, self).__init__(pusher)
        self.logger = logging.getLogger(__name__)
        self.config = config

    def run(self):
        self.logger.info('{}: NOTIFYING STAT TO UPDATE ITS CACHE'.format(self.__class__.__name__))
        for table in self.config['tables']:
            description = {
                'type': 'clickhouse',
                'connection': self.config['connection'],
                'table': table
            }
            self.pusher.push(
                self.config['notify_api_url'],
                data=description,
                headers=self.config['ya_stat_auth']['auth_headers']
            )
        self.logger.info('NOTIFICATIONS ARE SENT')
