# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from nile.api.v1 import extractors as ne

from .nile_monitorer import NileMonitorer


class DeterrenceDistributionMetricMonitorer(NileMonitorer):
    def __init__(self, date, pusher, provider, aggregator, config):
        super(DeterrenceDistributionMetricMonitorer, self).__init__(pusher, config)
        self.logger = logging.getLogger(__name__)
        self.date = date
        self.provider = provider
        self.aggregator = aggregator

    def run(self):
        self.logger.info('{}: BUILDING DETERRENCE DISTRIBUTION METRIC'.format(self.__class__.__name__))
        self.logger.info('DATE: {}'.format(self.date))
        self._run_internal()
        self.logger.info('BUILD COMPLETED')

    def _construct_job(self, cluster, job):
        extracts = {}
        for name, info in self.config['sources'].items():
            parts = [
                job.table(self._get_path(info['path_pattern'], self.date, shift))
                for shift in info['date_shift']
            ]
            extracts[name] = self.provider.get(name, job.concat(*parts))
        targets = self.aggregator.aggregate(extracts)
        targets['report'] = targets['report'].project(
            ne.all(),
            date=ne.const(self.date)
        ).put(
            self._get_path(self.config['targets']['report']['path_pattern'], self.date)
        )
        self.pusher.push(targets['report'])
