# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging
from getpass import getuser

from nile.api.v1 import clusters, files
from .monitorer_base import MonitorerBase
from ..utils.time import parse_date, shift_date


class NileMonitorer(MonitorerBase):
    def __init__(self, pusher, config):
        super(NileMonitorer, self).__init__(pusher)
        self.logger = logging.getLogger(__name__)
        self.config = config

    def _run_internal(self):
        cluster = clusters.YT(proxy=self.config['proxy'], pool=self.config['pool'])
        job = cluster.job().env(
            parallel_operations_limit=self.config['parallel_operations_limit'],
            package_paths=[self.config['wheels_path']],
            packages=self._get_packages()
        )
        self._construct_job(cluster, job)
        self._save_flows(job)
        job.run()
        self._post_process(cluster)

    def _construct_job(self, cluster, job):
        pass

    def _save_flows(self, job):
        self.logger.info('Saving operations graph')
        # job.flow_graph.save_to_file(
        #     '{}/flow_graph.png'.format(self.config['flows_path'])
        # )
        self.logger.info('Saving optimized operations graph')
        # job.optimized_flow_graph().save_to_file(
        #     '{}/optimized_flow_graph.png'.format(self.config['flows_path'])
        # )

    def _post_process(self, cluster):
        pass

    def _get_path(self, pattern, date, shift=None):
        shift = shift if shift else 0
        return pattern.format(shift_date(parse_date(date), shift))

    def _get_packages(self):
        packages = []
        for package in self.config['packages']:
            if package['type'] == 'develop_package':
                packages.append(files.DevelopPackage(package['path']))
            elif package['type'] == 'package':
                packages.append(files.Package(package['name']))
        return packages
