import logging

from .monitorer_base import MonitorerBase


class RtmrTableMonitorerBase(MonitorerBase):
    def __init__(self, pusher, provider, config):
        super(RtmrTableMonitorerBase, self).__init__(pusher)
        self.logger = logging.getLogger(__name__)
        self.provider = provider
        self.config = config

    def run(self):
        self.logger.info('{}: GATHERING STATS ON RTMR TABLES'.format(self.__class__.__name__))
        urls = {
            storage_name: self.config['rtmr_tables_stats_url_pattern'].format(storage_name)
            for storage_name in self.config['storages_tables']
        }
        self._run_internal(self._get_new_stats(urls))
        self.pusher.commit()
        self.logger.info('STATS ON RTMR TABLES ARE SENT')

    def _get_new_stats(self, urls):
        stats = {}
        for key, url in urls.items():
            self.logger.info('Retrieving stat for key {}'.format(key))
            stats[key] = self.provider.get(url)
        return stats
