# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .rtmr_table_monitorer_base import RtmrTableMonitorerBase


class RtmrTableStatsMonitorer(RtmrTableMonitorerBase):
    def __init__(self, pusher, provider, config):
        super(RtmrTableStatsMonitorer, self).__init__(pusher, provider, config)
        self.logger = logging.getLogger(__name__)

    def _run_internal(self, storages):
        for storage_name, tables_names in self.config['storages_tables'].items():
            if storage_name not in storages:
                self.logger.warning('No data available for storage {}'.format(storage_name))
            else:
                self.logger.info('For storage {} there are {} tables to monitor'.format(storage_name, len(tables_names)))
                storage_stats = storages[storage_name]
                for table_name in tables_names:
                    self.logger.info('Processing stats for table: {}'.format(table_name))
                    try:
                        table_stats = storage_stats[table_name]
                        for stats_name in self.config['stats_names']:
                            stats_value = table_stats[stats_name]
                            description = 'rtmr_{}_{}_{}'.format(storage_name, self.config['aliases'][table_name], stats_name)
                            self.pusher.push(description=description, value=stats_value, ts=table_stats['now'])
                    except Exception as error:
                        self.logger.error('Failed to process {} stats. Error: {}'.format(table_name, error))
