# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging
import datetime

from .rtmr_table_monitorer_base import RtmrTableMonitorerBase


class RtmrTableUpdatesMonitorer(RtmrTableMonitorerBase):
    def __init__(self, pusher, provider, config):
        super(RtmrTableUpdatesMonitorer, self).__init__(pusher, provider, config)
        self.logger = logging.getLogger(__name__)

    def _run_internal(self, storages):
        for storage_name, tables_names in self.config['storages_tables'].items():
            if storage_name not in storages:
                self.logger.warning('No data available for storage {}'.format(storage_name))
                self.pusher.push('No data found for storage {}'.format(storage_name))
                continue
            else:
                self.logger.info('For storage {} there are {} tables to monitor'.format(storage_name, len(tables_names)))
                storage_stats = storages[storage_name]
                for table_name in tables_names:
                    self.logger.info('Processing stats for table: {}'.format(table_name))
                    try:
                        table_stats = storage_stats[table_name]
                        seconds_lag = table_stats['lag']
                        if seconds_lag >= self.config['max_seconds_lag']:
                            self.pusher.push('Table {} was updated {} seconds ago'.format(
                                table_name, datetime.timedelta(seconds=seconds_lag)))
                        else:
                            self.logger.info('Table {} is up to date'.format(table_name))
                    except Exception as error:
                        self.logger.error('Failed to process {} stats. Error: {}'.format(table_name, error))
                        self.pusher.push('Can\'t inspect table {}. Invalid or missing stats.'.format(table_name))
