# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .nile_monitorer import NileMonitorer


class UidInstallMonitorer(NileMonitorer):
    def __init__(self, date, provider, config):
        super(UidInstallMonitorer, self).__init__(None, config)
        self.logger = logging.getLogger(__name__)
        self.date = date
        self.provider = provider

    def run(self):
        self.logger.info('{}: RUNNING'.format(self.__class__.__name__))
        self.logger.info('DATE: {}'.format(self.date))
        self._run_internal()
        self.logger.info('RUNNING COMPLETED')

    def _construct_job(self, cluster, job):
        path = self._get_path(self.config['sources'], self.date)
        table = self.provider.get(job.table(path))
        table.put(self._get_path(self.config['targets'], self.date))
