# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging
import base64
from Crypto.Cipher import Blowfish


class AdataParser(object):
    def __init__(self, config):
        super(AdataParser, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.config = config

    def parse(self, adata):
        source = base64.b64decode(adata.replace('-', '+').replace('_', '/'))
        block_size = Blowfish.block_size
        try:
            iv_decrypted = self.__decrypt(
                key=base64.b64decode(self.config['iv']['key']),
                mode=Blowfish.MODE_CBC,
                iv=self.config['iv']['iv'],
                encrypted=source[:block_size]
            )
        except:
            raise ValueError('Failed to decrypt iv')
        try:
            data_decrypted = self.__decrypt(
                key=base64.b64decode(self.config['key']),
                mode=Blowfish.MODE_CBC,
                iv=iv_decrypted,
                encrypted=source[block_size:]
            )
        except:
            raise ValueError('Failed to decrypt data from adata: {}'.format(adata))
        return data_decrypted.rstrip(b'\x00').decode('utf8')

    def __decrypt(self, key, mode, iv, encrypted):
        cipher = Blowfish.new(key, mode, iv)
        return cipher.decrypt(encrypted)
