# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from ..utils.json import decode_json


class JsonParser(object):
    def __init__(self):
        super(JsonParser, self).__init__()
        self.logger = logging.getLogger(__name__)

    def parse(self, text):
        try:
            return decode_json(text)
        except (ValueError, TypeError) as error:
            self.logger.exception('Can\'t parse json. Error: {}.'.format(error))
