# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .json_parser import JsonParser
from ..utils.tools import parse_key_value_string


class RtmrJsonParserBase(JsonParser):
    def __init__(self):
        super(RtmrJsonParserBase, self).__init__()
        self.logger = logging.getLogger(__name__)

    def _parse_counts(self, stat, extract_table=None):
        counts = parse_key_value_string(stat, delimeter='=')
        statistic = {'counts': counts}
        if extract_table is not None:
            for key, name in extract_table.items():
                statistic[name] = statistic['counts'].pop(key, 'unknown')
        statistic['counts'] = self._validate_counts(statistic['counts'])
        return statistic

    def _validate_counts(self, counts):
        valid = {}
        for key, count in counts.items():
            try:
                count = float(count)
            except (ValueError, TypeError) as error:
                self.logger.exception(
                    'Failed to parse key {} with '
                    'count {}. Error: {}'.format(key, count, error)
                )
                count = 0
            valid[key] = count
        return valid

    @classmethod
    def _get_ts(cls, nasty_rtmr_ts):
        rtmr_maxts = 9223372036854775807
        return rtmr_maxts - nasty_rtmr_ts

    @classmethod
    def _get_host_by_candidate(cls, candidate):
        return candidate.split('/')[0]

    @classmethod
    def _get_bannerid_by_candidate(cls, candidate):
        return candidate.split('/')[-1]
