# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .json_parser import JsonParser
from ..utils.time import get_now_ts


class RtmrTableStatsParser(JsonParser):
    def __init__(self):
        super(RtmrTableStatsParser, self).__init__()
        self.logger = logging.getLogger(__name__)

    def parse(self, text):
        storage_json = super(RtmrTableStatsParser, self).parse(text)
        try:
            parsed = {}
            for table_stats in storage_json['TableStats']:
                table_name = table_stats['Name']
                if table_stats['Stats']:
                    update_ts = int(table_stats['Stats']['LastUpdate'] / 1e6)
                    now_ts = get_now_ts()
                    bytes_count = table_stats['Stats']['BytesCount']
                    keys_count = table_stats['Stats']['KeysCount']
                    entries_count = table_stats['Stats']['EntriesCount']
                    parsed[table_name] = {'lag': now_ts - update_ts,
                                          'now': now_ts,
                                          'update_ts': update_ts,
                                          'bytes_count': bytes_count,
                                          'keys_count': keys_count,
                                          'entries_count': entries_count}
                else:
                    parsed[table_name] = {}
                    self.logger.error('No stats for table {}'.format(table_name))
        except Exception as error:
            self.logger.info('Failed to parse json. Error: {}'.format(error))
            parsed = {}
        return parsed
