
# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging


class ShowidParser(object):
    def __init__(self, config):
        super(ShowidParser, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.config = config

    def parse(self, showid, default=None):
        return (
            self.get_subclient(showid, default),
            self.get_client(showid, default),
            self.get_browser(showid, default),
            self.get_os(showid, default)
        )

    def get_subclient(self, showid, default=None):
        try:
            return self.config['subclient'].get(showid[:2], default)
        except Exception:
            return default

    def get_client(self, showid, default=None):
        try:
            return self.config['client'].get(showid[2:4], default)
        except Exception:
            return default

    def get_browser(self, showid, default=None):
        try:
            return self.config['browser'].get(showid[4:6], default)
        except Exception:
            return default

    def get_os(self, showid, default=None):
        try:
            return self.config['os'].get(showid[6:8], default)
        except Exception:
            return default
