# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .json_provider import JsonProvider


class AbTestidsProvider(object):
    def __init__(self, config):
        self.logger = logging.getLogger(__name__)
        self.provider = JsonProvider()
        self.config = config

    def get(self):
        aspects = self.config['aspects']
        url = self.config['url']
        testids = []
        for aspect in aspects:
            try:
                aspect_tasks = self.provider.get(url.format(aspect))
            except Exception:
                aspect_tasks = []
                self.logger.critical('Failed to retrieve testids for aspect {}'.format(aspect))
            for task in aspect_tasks:
                if task['state'] in {'IN_CONFIG', 'RUNNING', 'STOPPED', 'CLOSED'}:
                    # testids.extend(task['testids'])
                    testids.extend([format(testid) for testid in task['testids']])
        return testids
