# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .arcadia_text_provider import ArcadiaTextProvider


class ArcadiaTestidsProvider(object):
    def __init__(self, config):
        super(ArcadiaTestidsProvider, self).__init__()
        self.config = config
        self.provider = ArcadiaTextProvider(config)
        self.logger = logging.getLogger(__name__)

    def get(self):
        text = self.provider.get(self.config['testids_path'])
        testids = []
        for line in text.split('\n'):
            testid = line.strip()
            if testid:
                testids.append(testid)
        return testids
