# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import codecs
import logging

from .text_provider import TextProvider


class ArcadiaTextProvider(object):
    def __init__(self, config):
        super(ArcadiaTextProvider, self).__init__()
        self.config = config
        self.provider = TextProvider()
        self.logger = logging.getLogger(__name__)

    def get(self, arcadia_path):
        texts_url = '{}/{}'.format(
            self.config['arcanum_api'],
            arcadia_path
        )
        # XXX
        # Workaround for SSL Warning
        import warnings
        with warnings.catch_warnings():
            warnings.simplefilter('ignore')
            text = self.provider.get(texts_url, headers=self.__get_headers(), verify=False)
        # XXX
        if text is None:
            self.logger.critical('Can\'t download text from {}'.format(arcadia_path))
            return ''
        return text

    def __get_headers(self):
        return {'Authorization': 'OAuth {}'.format(self.config['arcanum_token'])}

