# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .json_provider import JsonProvider


class AtomCollectionsDataProvider(object):
    def __init__(self, config):
        super(AtomCollectionsDataProvider, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.provider = JsonProvider()
        self.config = config
        self.__collection = None

    def get(self):
        lists = set()
        for collection in self.__get_collections():
            if isinstance(collection, basestring):
                lists.add(collection)
            elif isinstance(collection, dict):
                for name, trie in collection.items():
                    for candidates_list in trie:
                        lists.add(candidates_list)
        return list(lists)

    def __get_collections(self):
        collection_url = '{}{}/collections/{}'.format(
            self.config['atom_admin_url'],
            self.config['atom_admin_api'],
            self.config['collection_name']
        )
        collections = self.provider.get(collection_url, headers=self.__get_headers())
        if collections is None:
            self.logger.critical('Can\'t download candidates lists')
            return []
        return collections

    def __get_headers(self):
        # with codecs.open(self.config['atom_admin_token_path'], 'r') as atom_admin_token_file:
        #     atom_admin_token = atom_admin_token_file.read().strip()
        return {'Authorization': 'Token {}.'.format(self.config['atom_admin_token'])}
