# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .arcadia_text_provider import ArcadiaTextProvider


class AtomContextProvider(object):
    def __init__(self, config):
        super(AtomContextProvider, self).__init__()
        self.config = config
        self.provider = ArcadiaTextProvider(config)
        self.logger = logging.getLogger(__name__)

    def get(self):
        return self.__parse_contexts(self.provider.get(self.config['contexts_path']))

    def __parse_contexts(self, text):
        contexts = {
            name: {}
            for type_, name in self.config['context_types'].items()
        }
        for line in text.split('\n'):
            if line:
                type_, code, value = line.split('\t')
                contexts[self.config['context_types'][type_]][code] = value
        return contexts
