# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

from nile.api.v1 import Record


class AtomDistributionAlertsSlicesProvider(object):
    def __init__(self):
        super(AtomDistributionAlertsSlicesProvider, self).__init__()

    def get(self, source, config):
        return source.map(
            AtomDistributionAlertsSlicesMapper(config)
        )


class AtomDistributionAlertsSlicesMapper(object):
    def __init__(self, config):
        super(AtomDistributionAlertsSlicesMapper, self).__init__()
        self.config = config

    def __call__(self, records):
        mask = [
            name in self.config['dimensions']
            for name in self.config['all_dimensions']
        ]
        event = self.config['event']
        for record in records:
            segment = '\t'.join([record[name] or '' for name in self.config['all_dimensions']])
            if self.__is_needed_segment(segment, mask) and event in record:
                yield Record(
                    key='{}\t{}'.format(event, segment),
                    date=record['date'],
                    count=record[event],
                    signature=tuple(zip(self.config['all_dimensions'], mask))
                )

    def __is_needed_segment(self, segment, mask):
        for value, flag in zip(segment.split('\t'), mask):
            if not flag and value != '_total_':
                return False
        return True
