# -*- coding: utf-8 -*-
from __future__ import print_function, absolute_import, division

import logging


class CachingProviderDecorator(object):
    def __init__(self, provider):
        super(CachingProviderDecorator, self).__init__()
        self.provider = provider
        self.logger = logging.getLogger(__name__)
        self.__cache = {}

    def get(self, key):
        if key not in self.__cache:
            self.__cache[key] = self.provider.get(key)
        return self.__cache[key]

    def clear_cache(self):
        self.__cache.clear()
