# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from ..common.requester import Requester
from ..parsers.rtmr_detailed_json_parser import RtmrDetailedJsonParser


class DetailedJsonProvider(object):
    def __init__(self, config):
        super(DetailedJsonProvider, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.requester = Requester()
        self.parser = RtmrDetailedJsonParser(config)

    def get(self, url):
        return self.parser.parse(self.requester.get(url))
