# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging
import pandas


class IntegralDistributionMetricWeightsProvider(object):
    def __init__(self, config):
        super(IntegralDistributionMetricWeightsProvider, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.config = config

    def get(self):
        weights = {}
        channels_source = {
            'shows': 'host',
            'closes': 'host',
            'installs': 'product'
        }
        for channel, source in channels_source.items():
            scales = self.__get_weights(channel)
            weights[channel] = pandas.DataFrame({
                source: scales.keys(),
                'weight': scales.values()
            })
        return weights

    def __get_weights(self, channel):
        return self.config[channel]
