# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from ..parsers.json_parser import JsonParser
from ..common.requester import Requester


class JsonProvider(object):
    def __init__(self, **settings):
        super(JsonProvider, self).__init__(**settings)
        self.logger = logging.getLogger(__name__)
        self.parser = JsonParser()
        self.requester = Requester(**settings)

    def get(self, url, **kwargs):
        return self.parser.parse(self.requester.get(url, **kwargs))
