# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .caching_provider_decorator import CachingProviderDecorator
from .ya_stat_dictionary_provider import YaStatDictionaryProvider


class MobileAppsNameProvider(object):
    def __init__(self, config):
        super(MobileAppsNameProvider, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.config = config
        self.provider = CachingProviderDecorator(
            YaStatDictionaryProvider(self.config['ya_stat_provider'])
        )

    def get(self, by):
        apps_keys = self.provider.get(key='')
        naming = {}
        for project_name, mappings in apps_keys.items():
            if by in mappings:
                for key in mappings[by]:
                    naming[key] = project_name
        return naming
