# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from ..common.requester import Requester
from ..parsers.rtmr_table_stats_parser import RtmrTableStatsParser


class RtmrTableStatsProvider(object):
    def __init__(self):
        super(RtmrTableStatsProvider, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.requester = Requester()
        self.parser = RtmrTableStatsParser()

    def get(self, url):
        return self.parser.parse(self.requester.get(url))
