# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from nile.api.v1 import filters as nf


class UidInstallProvider(object):
    def __init__(self, config):
        super(UidInstallProvider, self).__init__()
        self.config = config
        self.logger = logging.getLogger(__name__)

    def get(self, source):
        self.logger.info('Extracting data for source')

        return source.filter(
            nf.equals('eventtype', self.config['eventtype']),
            nf.equals('past', 0)
        ).project(
            *self.config['fields']
        ).sort(
            *self.config['sort_fields']
        )
