# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .json_provider import JsonProvider


class YaStatDictionaryProvider(object):
    def __init__(self, config):
        super(YaStatDictionaryProvider, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.config = config
        self.dicts = {}

    def get(self, name=''):
        return self.__get_dictionary(name)

    def __get_dictionary(self, name):
        dictionary_url = '{}{}?name={}'.format(
            self.config['ya_stat_url'],
            self.config['dicts_api'],
            self.config['dicts_alias_pattern'].format(name),
            name
        )
        return JsonProvider().get(
            dictionary_url,
            headers=self.config['ya_stat_auth']['auth_headers'],
            verify=False
        )
