# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .mail_distribution_alerts_pusher import MailDistributionAlertsPusher
from .ya_stat_mart_distribution_alerts_pusher import YaStatMartDistributionAlertsPusher


class AtomDistributionAlertsPusher(object):
    def __init__(self, do_push=True):
        super(AtomDistributionAlertsPusher, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.do_push = do_push

    def push(self, alerts, config):
        self.logger.info('Pushing {} alerts'.format(len(alerts)))
        for notifier in self.__build_notifiers(config['notifiers']):
            notifier.push(alerts)

    def __build_notifiers(self, configs):
        builders = {
            'ya_stat_mart': self.__build_ya_stat_mart_notifier,
            'mail': self.__build_mail_notifier
        }
        return [
            builders[config['type']](config)
            for config in configs
        ]

    def __build_ya_stat_mart_notifier(self, config):
        return YaStatMartDistributionAlertsPusher(config, self.do_push)

    def __build_mail_notifier(self, config):
        return MailDistributionAlertsPusher(config, self.do_push)
