# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from nile.api.v1 import Record

from .nile_statface_pusher import NileStatfacePusher


class PrettifyMapper(object):
    def __init__(self):
        super(PrettifyMapper, self).__init__()

    def __call__(self, records):
        for record in records:
            context = record.to_dict()
            for key in context:
                if context[key] is None:
                    context[key] = '_empty_'
            context['fielddate'] = context.pop('date')
            yield Record(**context)


class AtomDistributionPusher(NileStatfacePusher):
    def __init__(self, config, do_push=True):
        super(AtomDistributionPusher, self).__init__(config, do_push)
        self.logger = logging.getLogger(__name__)

    def push(self, totals):
        self.logger.info('Preparing totals for pushing')
        super(AtomDistributionPusher, self).push(
            totals.map(
                PrettifyMapper()
            )
        )
