# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .razladki_pusher import RazladkiPusher


class BufferedRazladkiPusher(RazladkiPusher):
    def __init__(self, projects, do_push=False, timeout=None):
        super(BufferedRazladkiPusher, self).__init__(
            projects, do_push=do_push, timeout=timeout
        )
        self.logger = logging.getLogger(__name__)
        self.records = []

    def push(self, description, value, ts):
        self.logger.info('Will push to razladki {} = {}.'.format(description, value))
        record = {'param': description, 'value': value, 'ts': ts}
        self.records.append(record)

    def commit(self, override=False):
        self.logger.info('Pushing {} values'.format(len(self.records)))
        self._push_internal(self.records, self.projects, override)
        self.flush()

    def flush(self):
        self.records = []
