# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .sms_pusher import SmsPusher


class BufferedSmsPusher(SmsPusher):
    def __init__(self, notifee, do_push=True, timeout=None):
        super(BufferedSmsPusher, self).__init__(
            notifee, do_push=do_push, timeout=timeout
        )
        self.logger = logging.getLogger(__name__)
        self.message = ''

    def push(self, sms_text):
        self.logger.info('Appending sms_text: {} to message'.format(sms_text))
        self.message = ' '.join([self.message, sms_text])

    def commit(self):
        self._push_internal(self.notifee, self.message)
        self.flush()

    def flush(self):
        self.message = ''
