# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import io
import pandas
import logging

from .clickhouse_pusher import ClickhousePusher


class ClickhouseAtomPusher(ClickhousePusher):
    def __init__(self, config, do_push=True, timeout=None):
        super(ClickhouseAtomPusher, self).__init__(
            config, do_push=do_push, timeout=timeout
        )
        self.logger = logging.getLogger(__name__)
        self.tables = []

    def push(self, data):
        self.logger.info('Will push {} rows'.format(len(data)))
        self.__log_data_info(data)
        self.tables.append(data)

    def commit(self):
        dump = io.BytesIO()
        data = pandas.concat(self.tables)
        columns = [
            'event_date', 'host', 'product', 'event', 'region', 'referer', 'client',
            'subclient', 'browser', 'os', 'lists', 'update_ts', 'count'
        ]
        data.to_csv(dump, columns=columns, sep='\t', header=False)
        text = dump.getvalue()
        dump.close()
        self._push_internal(text.replace('u\'', '\''))
        self.flush()

    def flush(self):
        self.tables = []

    def _push_internal(self, text):
        self.logger.info('Actually pushing to clickhouse')
        super(ClickhouseAtomPusher, self).push(
            'POST',
            'INSERT INTO {} FORMAT TabSeparated'.format(self.config['table']),
            data=text
        )

    def __log_data_info(self, data):
        info = io.StringIO()
        data.info(verbose=True, buf=info)
        self.logger.info('Data info:\n{}'.format(info.getvalue()))
