# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .http_pusher import HttpPusher


class ClickhousePusher(HttpPusher):
    def __init__(self, config, do_push=True, timeout=None):
        super(ClickhousePusher, self).__init__(
            do_push=do_push, timeout=timeout
        )
        self.logger = logging.getLogger(__name__)
        self.config = config

    def push(self, method, query, *args, **kwargs):
        url = self.__construct_url()
        self.logger.info('Sending query:\n{}\nto {}'.format(query, self.config['clickhouse_host']))
        response = super(ClickhousePusher, self).push(method, url.format(query), *args, **kwargs)
        self.logger.log(
            logging.ERROR
            if (response is None or 'Exception' in response) else
            logging.INFO,
            'Response from clickhouse: {}'.format(response)
        )
        return response

    def __construct_url(self):
        return '{}/?user={}&password={}&query={{}}'.format(
            self.config['clickhouse_host'],
            self.config['clickhouse_auth']['user'],
            self.config['clickhouse_auth']['password']
        )
