# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from nile.api.v1 import extractors as ne

from .nile_statface_pusher import NileStatfacePusher


class DeterrenceDistributionMetricPusher(NileStatfacePusher):
    def __init__(self, config, do_push=True):
        super(DeterrenceDistributionMetricPusher, self).__init__(config, do_push)
        self.logger = logging.getLogger(__name__)

    def push(self, totals):
        self.logger.info('Preparing report for pushing')
        super(DeterrenceDistributionMetricPusher, self).push(
            totals.project(
                ne.all(exclude=('date',)),
                fielddate='date'
            )
        )
