# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from ..common.requester import Requester


class HttpPusher(object):
    def __init__(self, do_push=True, timeout=None):
        super(HttpPusher, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.requester = Requester()
        self.timeout = timeout
        self.do_push = do_push

    def push(self, method, url, *args, **kwargs):
        kwargs.setdefault('timeout', self.timeout)
        return (
            ''
            if not self.do_push else
            self.requester.request(method, url, *args, **kwargs)
        )
