# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .buffered_razladki_pusher import BufferedRazladkiPusher


class IntegralDistributionMetricPusher(BufferedRazladkiPusher):
    def __init__(self, config, do_push=True, timeout=None):
        super(IntegralDistributionMetricPusher, self).__init__(
            config['projects'], do_push=do_push, timeout=timeout
        )
        self.config = config

    def push(self, data):
        self._push_stats(data['weights'], prefix='idm_weight', value='weight', ts='update_ts')
        self._push_stats(data['stats'], prefix='idm_original', value='count', ts='update_ts')
        self._push_stats(data['weighted_stats'], prefix='idm_weighted', value='count', ts='update_ts')
        self._push_stats(data['integral_stats'], prefix='idm_integral', value='count', ts='update_ts')
        self._push_total(data['total'], prefix='idm_total', value='count', ts='update_ts')

    def _push_stats(self, stats, prefix, value, ts):
        channel_sources = {'installs': 'product', 'shows': 'host', 'closes': 'host'}
        for channel, source in channel_sources.items():
            for index, row in stats[channel].iterrows():
                name = '{}_{}_{}'.format(prefix, channel, row[source])
                super(IntegralDistributionMetricPusher, self).push(name, row[value], row[ts])

    def _push_total(self, stats, prefix, value, ts):
        for index, row in stats.iterrows():
            name = '{}'.format(prefix)
            super(IntegralDistributionMetricPusher, self).push(name, row[value], row[ts])
