# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import copy
import logging


class MemoryPusher(object):
    def __init__(self):
        super(MemoryPusher, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.__vault = None

    def push(self, data):
        self.__vault = copy.deepcopy(data)

    def get_value(self):
        return self.__vault
