# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging


from nile.api.v1 import (
    Record,
    statface as ns
)


class NileStatfacePusher(object):
    def __init__(self, config, do_push=True):
        super(NileStatfacePusher, self).__init__()
        self.logger = logging.getLogger(__name__)
        self.config = config
        self.do_push = do_push

    def push(self, stream):
        self.logger.info('Pushing stream to statface')
        if self.do_push:
            stream.publish(
                self._make_report()
            )

    def _make_report(self):
        return ns.StatfaceReport(
        ).path(
            self.config['report']['path']
        ).scale(
            self.config['report']['scale']
        ).replace_mask(
            *self.config['report']['replace_mask']
        ).client(
            self._make_client()
        )

    def _make_client(self):
        return ns.StatfaceProductionClient(
            username=self.config['ya_stat_auth']['auth_headers']['StatRobotUser'],
            password=self.config['ya_stat_auth']['auth_headers']['StatRobotPassword']
        )

