# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .http_pusher import HttpPusher


class PostPusher(HttpPusher):
    def __init__(self, do_push=True, timeout=None):
        super(PostPusher, self).__init__(
            do_push=do_push, timeout=timeout)
        self.logger = logging.getLogger(__name__)

    def push(self, url, data=None, json=None, **kwargs):
        return super(PostPusher, self).push('POST', url, data=data, json=json, **kwargs)
