# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .buffered_razladki_pusher import BufferedRazladkiPusher


class RazladkiAtomPusher(BufferedRazladkiPusher):
    def __init__(self, config, do_push=True, timeout=None):
        super(RazladkiAtomPusher, self).__init__(
            config['projects'], do_push=do_push, timeout=timeout
        )
        self.config = config
        self.dimensions_shortcuts = {
            'host': 'h', 'product': 'p', 'region': 'r', 'referer': 'f',
            'client': 'c', 'subclient': 's', 'browser': 'b', 'os': 'o', 'list': 'l'
        }
        self.logger = logging.getLogger(__name__)

    def push(self, data):
        for signature, slice_ in data.items():
            for index, row in slice_.iterrows():
                description = self.__build_description(row, signature)
                super(RazladkiAtomPusher, self).push(
                    description,
                    row['count'],
                    row['update_ts']
                )

    def __build_description(self, row, signature):
        dimensions = [dimension for dimension, flag in signature if flag]
        shortcuts = [self.dimensions_shortcuts[dimension] for dimension in dimensions]
        slice_name = [row[dimension] for dimension in dimensions]
        return '{}{}_{}_{}'.format(
            self.config['prefix'],
            ''.join(shortcuts),
            '_'.join(slice_name),
            row['event']
        )
