# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging
import requests

from .post_pusher import PostPusher


class RazladkiPusher(PostPusher):
    def __init__(self, projects, do_push=False, timeout=None):
        super(RazladkiPusher, self).__init__(
            do_push=do_push, timeout=timeout
        )
        self.logger = logging.getLogger(__name__)
        self.projects = projects

    def push(self, description, value, ts, override=False):
        self.logger.info('Will push to razladki {} = {}.'.format(description, value))
        records = [{'param': description, 'value': value, 'ts': ts}]
        self._push_internal(records, self.projects, override)

    def _push_internal(self, records, projects, override):
        for project in projects:
            self.logger.info('Actually pushing to razladki. Project: {}.'.format(project))
            url = 'http://launcher.razladki.yandex-team.ru/save_new_data_json/{}'.format(project)
            super(RazladkiPusher, self).push(
                url,
                json={'data': records, 'override': override}
            )
