# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging
import urllib

from .get_pusher import GetPusher


class SmsPusher(GetPusher):
    def __init__(self, notifee, do_push=True, timeout=None):
        super(SmsPusher, self).__init__(
            do_push=do_push, timeout=timeout
        )
        self.logger = logging.getLogger(__name__)
        self.notifee = notifee

    def push(self, sms_text):
        return self._push_internal(self.notifee, sms_text)

    def _push_internal(self, notifee, sms_text):
        if sms_text:
            self.logger.info('Message for {}: {}'.format(notifee, sms_text))
            self.logger.info('Sending sms to {}'.format(notifee))
            golem_url = 'https://golem.yandex-team.ru/api/sms/send.sbml?resps={}&msg={}'
            recipients = ','.join(notifee)
            text = urllib.quote(sms_text.encode('utf8').decode('utf8'))
            return super(SmsPusher, self).push(golem_url.format(recipients, text))
