# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import sys
import json
import codecs


def print_json(data, indent=4, file=sys.stdout):
    print(encode_json(data, indent=indent), file=file)


def safe_decode_json(string):
    try:
        return decode_json(string)
    except Exception:
        return None


def safe_encode_json(data, indent=None):
    try:
        return encode_json(string)
    except Exception:
        return None


def decode_json(string):
    return json.loads(string)


def encode_json(data, indent=None):
    return json.dumps(data, indent=indent)


def load_json(path, mode='r'):
    with codecs.open(path, mode) as file_:
        return json.load(file_)


def save_json(path, data, mode='w'):
    with codecs.open(path, mode) as file_:
        json.dump(data, file_)
