# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import datetime


def format_date(date, fmt):
    return date.strftime(fmt)


def parse_date(date, fmt='%Y-%m-%d'):
    return datetime.datetime.strptime(date, fmt).date()


def safe_parse_date(date):
    return parse_date(date) if date is not None else date


def get_now():
    return datetime.datetime.now()


def get_now_ts():
    return to_ts(get_now())


def get_now_str(fmt='%Y-%m-%d %H:%M:%S'):
    return datetime.datetime.now().strftime(fmt)


def to_ts(date):
    return int(date.strftime('%s'))


def shift_date(date, shift):
    return date + datetime.timedelta(days=shift)


def next_date(date):
    return shift_date(date, 1)


def previous_date(date):
    return shift_date(date, -1)


def get_today():
    return datetime.date.today()


def get_yesterday():
    return previous_date(get_today())


def get_tomorrow():
    return next_date(get_today())


def from_ordinal(ordinal):
    return datetime.date.fromordinal(ordinal)
